#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/pl2ymapsdf/names.h>

#include <maps/libs/common/include/exception.h>

#include <boost/algorithm/string/trim.hpp>

namespace maps::wiki::pl2ymapsdf {

namespace {

const std::string NAME_PREFIX = "name_";

std::string trim(std::string str)
{
    boost::algorithm::trim(str);
    return str;
}

} // namespace


void NamesBase::check(Id id) const
{
    REQUIRE(!empty(), "empty names for id: " << id);
}

void NamesBase::parse(const pqxx::row& row, const std::string& nmPrefix)
{
    auto add = [&](auto code, auto lang, const auto& nonEqual) {
        auto nm = row[nmPrefix + code].c_str();
        return addName(nm, lang, nonEqual);
    };

    add("nat", LOCAL_LANG, EMPTY);
}

std::string NamesBase::addName(std::string nm, std::string_view lang, const std::string& nonEqual)
{
    auto name = trim(std::move(nm));
    if (!name.empty() && name != nonEqual) {
        langToName_.emplace(lang, name);
    }
    return name;
}


Names::Names(const pqxx::row& row)
{
    parse(row, NAME_PREFIX);
}

void Names::addLocal(std::string name)
{
    addName(std::move(name), LOCAL_LANG, EMPTY);
}

} // namespace maps::wiki::pl2ymapsdf
