#pragma once

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/pl2ymapsdf/common.h>

#include <pqxx/pqxx>
#include <unordered_map>

namespace maps {
namespace wiki {
namespace pl2ymapsdf {

class NamesBase
{
public:
    bool empty() const { return langToName_.empty(); }

    void check(Id id) const;

    const auto& langToName() const { return langToName_; }

protected:
    void parse(const pqxx::row& row, const std::string& nmPrefix);

    std::string addName(std::string nm, std::string_view lang, const std::string& nonEqual);

private:
    std::unordered_map<std::string, std::string> langToName_;
};


class Names : public NamesBase
{
public:
    Names() = default;

    explicit Names(const pqxx::row& row);

    void addLocal(std::string name);
};

} // namespace pl2ymapsdf
} // namespace wiki
} // namespace maps
