#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/rdel-merger/database.h>

#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/string_utils.h>

namespace maps {
namespace wiki {
namespace rdel_merger {

Database::Database(const std::string& connStr, const std::string& schema)
    : conn_(connStr)
    , work_(conn_)
{
    work_.exec("SET search_path=" + schema + ",public");
}

pqxx::result Database::read(const Query& query, const std::string& context)
{
    flush();
    INFO() << "Loading " << context << " ...";

    auto rows = work_.exec(query.str());
    INFO() << "Loaded " << context << " : " << rows.size();
    return rows;
}

pqxx::result Database::exec(const Query& query)
{
    flush();
    return work_.exec(query.str());
}

void Database::write(const Query& query)
{
    writeBuffer_.emplace_back(query.str());
}

void Database::commit()
{
    flush();
    work_.commit();
}

void Database::flush()
{
    if (!writeBuffer_.empty()) {
        work_.exec(maps::wiki::common::join(writeBuffer_, ';'));
        writeBuffer_.clear();
    }
}

} // namespace rdel_merger
} // namespace wiki
} // namespace maps
