#pragma once

#include <maps/wikimap/mapspro/services/tasks-ng/lib/query.h>

#include <pqxx/pqxx>
#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace rdel_merger {

using Query = tasks_ng::Query;

class Database
{
public:
    Database(const std::string& connStr, const std::string& schema);

    pqxx::result read(const Query& query, const std::string& context);
    pqxx::result exec(const Query& query);

    void write(const Query& query);

    void commit();

private:
    void flush();

    pqxx::connection conn_;
    pqxx::work work_;

    std::vector<std::string> writeBuffer_;
};

} // namespace rdel_merger
} // namespace wiki
} // namespace maps
