#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/rdel-merger/merger.h>
#include <maps/libs/cmdline/include/cmdline.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

namespace {
const auto MAX_VERTEXES_DEFAULT = 200;
const auto MAX_LENGTH_DEFAULT = 10000;
} // namespace


int main(int argc, char* argv[])
{
    try {
        maps::cmdline::Parser parser;
        auto connStr = parser.string("conn")
            .help("connection string to DB").required();
        auto schema = parser.string("schema")
            .defaultValue("ymapsdf")
            .help("YMAPSDF schema name");
        auto maxVertexes = parser.size_t("max-vertexes")
            .defaultValue(MAX_VERTEXES_DEFAULT)
            .help("Limit vertexes for line (default: " + std::to_string(MAX_VERTEXES_DEFAULT) + ")");
        auto maxLength = parser.real("max-length")
            .defaultValue(MAX_LENGTH_DEFAULT)
            .help("Max length for line (meters, default: " + std::to_string(MAX_LENGTH_DEFAULT) + ")");
        auto dryRun = parser.flag("dry-run")
            .help("Skip commit into database");
        parser.parse(argc, argv);

        INFO() << "DB: " << connStr;
        INFO() << "Schema: " << schema;
        INFO() << "Max vertexes: " << maxVertexes;
        INFO() << "Max length: " << maxLength;
        maps::wiki::rdel_merger::Merger merger(connStr, schema, maxVertexes, maxLength);
        merger.run();
        if (dryRun.defined()) {
            INFO() << "Skip commit into database";
        } else {
            merger.commit();
        }
        return 0;
    } catch (const maps::Exception& mex) {
        ERROR() << mex;
    } catch (const std::exception& ex) {
        ERROR() << ex.what();
    } catch (...) {
        ERROR() << "Unknown exception";
    }
    return 1;
}
