#pragma once

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/rdel-merger/database.h>

#include <cstdint>
#include <unordered_map>
#include <unordered_set>
#include <vector>

namespace maps {
namespace wiki {
namespace rdel_merger {

using Id = int64_t;
using Ids = std::unordered_set<Id>;

class Merger
{
public:
    Merger(
        const std::string& connStr,
        const std::string& schema,
        size_t maxVertexes,
        double maxLength);

    void run();

    void commit() { db_.commit(); }

private:
    const Ids& roadIds(Id rdElId) const;
    const Ids& condIds(Id rdElId) const;

    void loadRoads();
    void loadConds();
    void loadElements();

    Id findErrorRdEl(Id rdElId = 0);
    void fixRdElDirection(Id rdElId);

    size_t doWork();
    std::unordered_map<Id, std::vector<Id>> loadRdJcToRdEls();

    Database db_;
    const size_t maxVertexes_;
    const double maxLength_;

    std::unordered_map<Id, Ids> rdElToRoads_;
    std::unordered_map<Id, Ids> rdElToConds_;
    Ids protectedRdElIds_;
};

} // namespace rdel_merger
} // namespace wiki
} // namespace maps
