#pragma once

#include <maps/wikimap/mapspro/tools/ymapsdf-conversion/shp2ymapsdf/common.h>

#include <pqxx/pqxx>
#include <vector>

namespace maps::wiki::shp2ymapsdf {

class Database
{
public:
    Database(
        const std::string& connStr,
        const std::string& srcSchema,
        const std::string& dstSchema);

    const auto& srcSchema() const { return srcSchema_; }

    pqxx::result read(
        const Query& query,
        const std::string& context,
        const std::string& groupKey = "gid");

    void write(const Query& query);

    Id maxId(const std::string& table, std::string key = "");
    Id countryId();

    void commit();

    std::string quote(const std::string& str) const;

    std::string toGeom(const std::string& wkb) const;

private:
    void flush();

    const std::string srcSchema_;
    const std::string dstSchema_;

    pqxx::connection connR_;
    pqxx::work workR_;
    pqxx::connection connW_;
    pqxx::work workW_;

    std::vector<std::string> writeBuffer_;
};

} // namespace maps::wiki::shp2ymapsdf
