#!/bin/bash

usage() {
    echo "Usage $0 <pass>"
    echo "pass=1 - check paths"
    echo "pass=2 - shp2pgsql"
    echo "pass=3 - ymapsdf create"
    echo "pass=4 - process"
    echo "pass=5 - ymapsdf finalize,integrity"
    echo "pass=6 - rdel merger"
    echo "pass=7 - topo fixer"
    echo "pass=8 - ymapsdf2json"
    echo "pass=9 - import"
    echo "pass=10 - sync"
    echo "..."
    exit 1
}

if test -z "$1"; then
    usage
fi

TMP="./tmp"
TNC=transnavicom
SHAPESDIR="./$TNC"
JSONDIR="./json"
PGCONN=postgresql://mapspro:mapspro@pg95.maps.dev.yandex.net:5432/mapspro_ponomarev_ymapsdf
YMAPSDF_SCHEMA=ymapsdf
YMAPSDF_SCHEMA_FIXED=ymapsdf_fixed
#SERVICES_XML="../../../../cfg/services/services.local.$USER.xml"
SERVICES_XML="../../../../cfg/services/services.local.$USER.il2.xml"
RESTRICTIONS_AD_XML="../../../topology_fixer/configs/restrictions.ukraine.ad.xml"
TNC2YMAPSDF="../tnc2ymapsdf"
RDEL_MERGER="../../rdel-merger/rdel-merger"
MAX_YMAPSDF_ID="../../../topology_fixer/bin/max-ymapsdf-id/max-ymapsdf-id"
TOPOLOGY_FIXER="../../../topology_fixer/bin/topology-fixer/topology-fixer"
YMAPSDF2JSON="../../ymapsdf2json/bin/ymapsdf2json"
JSON2TDS="../../../json2tds/json2tds"
WIKI_EDITOR_TOOL="../../../../services/editor/src/bin/tool/wiki-editor-tool"

YMAPSDF_CREATE=/usr/share/yandex/maps/ymapsdf2/ymapsdf_import_create.sql
YMAPSDF_FINALIZE=/usr/share/yandex/maps/ymapsdf2/ymapsdf_import_finalize.sql
YMAPSDF_INTEGRITY=/usr/share/yandex/maps/ymapsdf2/ymapsdf_import_integrity.sql

if [ "$1" = "1" ]; then
echo "Check symlinks before hard work"

for i in "$SHAPESDIR" "$SERVICES_XML" "$TNC2YMAPSDF" "$RDEL_MERGER" \
    "$YMAPSDF_CREATE" "$YMAPSDF_FINALIZE" "$YMAPSDF_INTEGRITY" \
    "$MAX_YMAPSDF_ID" "$TOPOLOGY_FIXER" "$RESTRICTIONS_AD_XML" \
    "$YMAPSDF2JSON" "$JSON2TDS" "$WIKI_EDITOR_TOOL"
do
    echo "Check path $i"
    if (test -e "$i") then
        echo "$i ok"
    else
        echo "$i NOT EXISTS"
    fi
    echo
done


elif [ "$1" == "2" ] ; then
rm -rf $TMP
mkdir -p $TMP

#creating sql's
rm -f log
for i in `ls -1 $SHAPESDIR/*.shp`; do
    a=`echo $i|rev|cut -f1 -d/ |rev|cut -f1 -d'.'`
    echo $i >>log
    shp2pgsql $i $TNC.$a -S -I > $TMP/$a.sql 2>>log
    echo >>log
done

#cleanup
psql $PGCONN -c "DROP SCHEMA IF EXISTS $TNC CASCADE; CREATE SCHEMA $TNC"

#creating tables
for i in `ls -1 $TMP/*.sql`; do
    echo "Processing $i" >>log
    psql $PGCONN < $i >>log
    echo >>log
done


elif [ "$1" = "3" ]; then

for i in "$YMAPSDF_SCHEMA" "$YMAPSDF_SCHEMA_FIXED"; do
    #create ymapsdf schema
    psql $PGCONN -c "DROP SCHEMA IF EXISTS $i CASCADE; CREATE SCHEMA $i"

    #ymapsdf_import_create.sql
    echo "SET SEARCH_PATH=$i,public;" > $TMP/tmp.sql
    cat $YMAPSDF_CREATE >> $TMP/tmp.sql
    psql $PGCONN < $TMP/tmp.sql
done


elif [ "$1" = "4" ]; then

$TNC2YMAPSDF --conn $PGCONN --src $TNC --dst $YMAPSDF_SCHEMA --stages atd 2>&1 2> tnc2ymapsdf.$YMAPSDF_SCHEMA.log &
$TNC2YMAPSDF --conn $PGCONN --src $TNC --dst $YMAPSDF_SCHEMA_FIXED --stages atd,roads,addrs,buildings 2>&1 2> tnc2ymapsdf.$YMAPSDF_SCHEMA_FIXED.log
#$TNC2YMAPSDF --conn $PGCONN --src $TNC --dst $YMAPSDF_SCHEMA_FIXED --stages atd,roads 2>&1 2> tnc2ymapsdf.$YMAPSDF_SCHEMA_FIXED.log
#$TNC2YMAPSDF --conn $PGCONN --src $TNC --dst $YMAPSDF_SCHEMA_FIXED --stages atd,roads,addrs 2>&1 2> tnc2ymapsdf.$YMAPSDF_SCHEMA_FIXED.log


elif [ "$1" = "bld" ]; then

$TNC2YMAPSDF --conn $PGCONN --src $TNC --dst $YMAPSDF_SCHEMA_FIXED --stages buildings 2>&1 2>tnc2ymapsdf.$YMAPSDF_SCHEMA_FIXED.bld.log


elif [ "$1" = "hydro" ]; then

$TNC2YMAPSDF --conn $PGCONN --src $TNC --dst $YMAPSDF_SCHEMA --stages hydro 2>&1 2>tnc2ymapsdf.$YMAPSDF_SCHEMA.hydro.log
$TNC2YMAPSDF --conn $PGCONN --src $TNC --dst $YMAPSDF_SCHEMA_FIXED --stages hydro 2>&1 2>tnc2ymapsdf.$YMAPSDF_SCHEMA_FIXED.hydro.log


elif [ "$1" = "5" ]; then

for i in "$YMAPSDF_SCHEMA" "$YMAPSDF_SCHEMA_FIXED"; do
    #ymapsdf_import_finalize.sql
    echo "SET SEARCH_PATH=$i,public;" > $TMP/tmp.sql
    cat $YMAPSDF_FINALIZE >> $TMP/tmp.sql
    psql $PGCONN < $TMP/tmp.sql

    #ymapsdf_import_integrity.sql
    echo "SET SEARCH_PATH=$i,public;" > $TMP/tmp.sql
    cat $YMAPSDF_INTEGRITY >> $TMP/tmp.sql
    psql $PGCONN < $TMP/tmp.sql
done


elif [ "$1" = "6" ]; then

echo "Start rdel-merger"
$RDEL_MERGER --conn $PGCONN --schema $YMAPSDF_SCHEMA_FIXED \
    --max-vertexes 200 --max-length 10000 2>&1 2> rdel_merger.log


elif [ "$1" = "7" ]; then

TOPO_CMD="$TOPOLOGY_FIXER --threads 1 --conn $PGCONN --input-schema $YMAPSDF_SCHEMA --output-schema $YMAPSDF_SCHEMA_FIXED"

echo "topofixer"

for GROUP in "ad" "hydro_ln"
do
    MAX_ID=`$MAX_YMAPSDF_ID --conn $PGCONN --schema $YMAPSDF_SCHEMA_FIXED`
    echo "topo fix $GROUP, max id: $MAX_ID"
    $TOPO_CMD \
        --group $GROUP \
        --start-ymapsdf-id $MAX_ID \
        --restrictions-config $RESTRICTIONS_AD_XML 2>&1 2> topo.$GROUP.txt
done


elif [ "$1" = "8" ]; then

rm -rf $JSONDIR
mkdir -p $JSONDIR
$YMAPSDF2JSON --conn $PGCONN --schema $YMAPSDF_SCHEMA_FIXED --id-mode renumber --id-start-from 1 --output-dir $JSONDIR


elif [ "$1" = "9" ]; then

$JSON2TDS --input-dir $JSONDIR --user-id=82282794 --threads=20 --commit-ids-file commits.txt --cfg $SERVICES_XML 2>&1 2>log.txt


elif [ "$1" = "10" ]; then

$WIKI_EDITOR_TOOL --config $SERVICES_XML --all-objects=1 --set-progress-state=1 --branch-exclusive-lock=1 2>&1 2>sync0.log


else
    usage
fi
