#include "attribute_dumper.h"
#include "magic_strings.h"
#include "common.h"

namespace maps {

namespace {
bool
dumpAttribute(
    json::ObjectBuilder& builder,
    const std::string& ns,
    const std::string& name,
    const std::string& value)
{
    if (value.empty()) {
        return false;
    }
    auto nsName = name.find(':') == std::string::npos
        ? ns + ":" + name
        : name;
    builder[nsName] = value;
    return true;
}
} // namespace

void
dumpGeometry(
    json::ObjectBuilder& builder,
    const pqxx::row& tuple,
    const std::string& shapeName)
{
    bool dumped = dumpOptionalGeometry(builder, tuple, shapeName);
    REQUIRE(dumped, "id: " << tuple.at(ID).as<DBID>());
}

bool
dumpOptionalGeometry(
    json::ObjectBuilder& builder,
    const pqxx::row& tuple,
    const std::string& shapeName)
{
    const auto& shape = shapeName.empty() ? SHAPE : shapeName;
    const char* geojson = tuple.at(shape).c_str();
    if (!geojson || *geojson == 0) {
        return false;
    }
    builder[jkey::GEOMETRY] = json::Verbatim(geojson);
    return true;
}

AttributeDumper::AttributeDumper(
        const std::string& ns,
        json::ObjectBuilder& builder)
    : ns_(ns)
    , builder_(builder)
{ }

void
AttributeDumper::dumpCategory() const
{
    dumpCategory(ns_);
}

void
AttributeDumper::dumpCategory(const std::string& catName) const
{
    dumpAttribute(builder_, ns::CAT, catName, STR_TRUE);
}

template <>
bool
AttributeDumper::dump<bool>(
    const std::string& catName,
    const std::string& attrName,
    const bool& value) const
{
    return value ? dump(catName, attrName, STR_TRUE) : false;
}

template <>
bool
AttributeDumper::dump<std::string>(
    const std::string& catName,
    const std::string& attrName,
    const std::string& value) const
{
    return value.empty() ? false : dumpAttribute(builder_, catName, attrName, value);
}

} //maps
