#include "categories.h"

#if defined(CATEGORY_LIST) || defined(X)
#error macro CATEGORY_LIST or X already defined
#endif


#define CATEGORY_LIST                           \
    X(RD)                                       \
    X(RD_EL)                                    \
    X(RD_JC)                                    \
    X(RD_NM)                                    \
                                                \
    X(AD)                                       \
    X(AD_CNT)                                   \
    X(AD_EL)                                    \
    X(AD_JC)                                    \
    X(AD_FC)                                    \
    X(AD_SUBST_FC)                              \
    X(AD_NM)                                    \
                                                \
    X(ADDR)                                     \
    X(ADDR_NM)                                  \
                                                \
    X(FT)                                       \
    X(FT_FC_EL)                                 \
    X(FT_FC_JC)                                 \
    X(FT_FC)                                    \
    X(FT_LN_EL)                                 \
    X(FT_LN_JC)                                 \
    X(FT_NM)                                    \
                                                \
    X(BLD)                                      \
                                                \
    X(MODEL3D)                                  \
                                                \
    X(COND_DT)                                  \
    X(COND)                                     \
                                                \
    X(META)

namespace maps
{

#define X(A) extern const Category& A##_CATEGORY;

CATEGORY_LIST

#undef X


#define X(A) A##_CATEGORY,

const std::vector<std::reference_wrapper<const Category>> CATEGORIES = {
    CATEGORY_LIST
};

#undef X

Category::~Category() {}

std::string
Category::name() const
{
    return table().name;
}

std::string
Category::loadIdsSql() const
{
    return "SELECT DISTINCT " + table().id + " FROM " + table().name;
}

} // namespace maps
