#pragma once

#include "tables.h"
#include "relations.h"
#include <maps/libs/json/include/builder.h>

#include <pqxx/pqxx>

namespace maps {

class IdManager;

struct Category {
    virtual ~Category();
    virtual const Table& table() const = 0;
    virtual std::string name() const;
    virtual std::string loadIdsSql() const;
    virtual std::string loadRowsSqlTemplate() const = 0;
    virtual void tupleToJson(
        json::ObjectBuilder&,
        const pqxx::row&) const = 0;
};

extern const std::vector<std::reference_wrapper<const Category>> CATEGORIES;

}

#define DEFINE_CATEGORY_OBJECT(CategoryName, CategoryCapsName)             \
    static const CategoryName##Category CategoryCapsName##_CATEGORY_OBJECT; \
    const Category& CategoryCapsName##_CATEGORY = CategoryCapsName##_CATEGORY_OBJECT
