#pragma once

#include "json_chunk.h"
#include "params.h"

#include <memory>

namespace maps {

struct TaskContext;

class Writer {
public:
    virtual ~Writer();
    virtual void put(TaskContext& context, JsonChunk chunk) = 0;
    virtual void finish(TaskContext& context) = 0;
    static std::unique_ptr<Writer> make(const Params& params);
};

}
