#pragma once

#include "common.h"
#include "ft_type.h"
#include "relations.h"
#include "magic_strings.h"


namespace maps {

const std::string FT_PREFIX = "ft_";

class FtData {
public:
    FtData(const pqxx::row& tuple,
        const std::string& namePrefix = FT_PREFIX);

    bool isNull() const { return id_ == 0; }
    bool isTrivial() const { return isTrivial_; }
    DBID id() const { return id_; }
    DBID ftType() const { return ftType_; }
    bool hasFtTypeAttr() const;
    std::string partRole() const;
    std::string masterRole() const;
    std::string category(const std::string& origCategory = category::FT) const;
    Relation relation(const Relation& ftRel) const;
    Relation relation(const FtData& parentFt) const;

private:
    DBID id_;
    DBID ftType_;
    bool isTrivial_;
    IsPoint isPoint_;
};

std::string ftSql(
    const std::string& ftId,
    const std::string& ftPrefix = FT_PREFIX);

std::string ftMacroSql(
    const std::string& ftId,
    const std::string& ftPrefix = FT_PREFIX);

std::string ftElSql(
    const std::string& ftId,
    const std::string& edgeId,
    const std::string& ftPrefix = FT_PREFIX);

std::string ftFcElSql(
    const std::string& edgeId,
    const std::string& ftPrefix = FT_PREFIX);

std::string ftFcJcSql(
    const std::string& nodeId,
    const std::string& ftPrefix = FT_PREFIX);

std::string isTrivialSql(
    const std::string& ftId);

} // namepsace maps
