#pragma once

#include "common.h"
#include "ymapsdf2json.h"
#include "params.h"
#include "tables.h"

namespace maps {

void initIdManager(const Params& params);

void registerIds(const Table& table, const std::vector<DBID>& ids);
std::string convertId(const Table& table, DBID oId);
void completeIdRegistration(pqxx::transaction_base& tr, size_t batchSize);
DBID maxId();

} // namespace maps
