#include "params.h"

#include <maps/libs/common/include/exception.h>

namespace maps {

DbParams::DbParams()
    : maxConnections(20)
{}

Params::Params()
    : idMode(IdMode::Renumber)
    , fileNamePattern("%|1$|_%|2$06d|.json")
    , objectsPerFile(10000)
    , objectsPerDbRead(1000)
    , idStartFrom(1)
{}

void Params::validate() const
{
    REQUIRE(db.maxConnections >= 2, "at least 2 db connections needed");
    REQUIRE(db.maxConnections <= 20, "at most 20 db connections allowed");
}

PoolSizes::PoolSizes(unsigned maxConnections)
    : fileWritePoolSize(10)
{
    // allocating 1/3 of connections for ids loading, but min 1
    loadIdsPoolSize = std::max(1u, maxConnections / 3u);
    // all remaining connections allocated for rows loading
    loadRowsPoolSize = maxConnections - loadIdsPoolSize;
    // total connections must be no less than total threads
    // loadRows will be working until all data processed
    connPoolSize = loadRowsPoolSize;
    // loadIdsPool will finish early, extra connections will be freed
    connPoolOverflow  = loadIdsPoolSize;
}

}
