#pragma once

#include <string>
#include <set>

namespace maps {

enum class IdMode {
    KeepOriginal,
    Renumber
};

struct DbParams {
    DbParams();

    std::string connString;
    std::string schema;
    unsigned int maxConnections;
};

struct Params {
    Params();

    bool isSplit() const {
        return !outputDir.empty();
    }

    void validate() const;

    DbParams db;
    IdMode idMode;
    std::string outputDir;
    std::string outputFile;
    std::string fileNamePattern;
    size_t objectsPerFile;
    size_t objectsPerDbRead;
    size_t idStartFrom;
    std::set<std::string> categories;
};

struct PoolSizes {
    explicit PoolSizes(unsigned maxConnections);
    unsigned connPoolSize;
    unsigned connPoolOverflow;
    size_t loadIdsPoolSize;
    size_t loadRowsPoolSize;
    size_t fileWritePoolSize;
};

} // maps
