#pragma once

#include "id_manager.h"
#include "relations.h"
#include "ft_type.h"

#include <maps/libs/json/include/builder.h>

namespace maps {

class RelationDumper {
public:
    RelationDumper(
        json::ArrayBuilder& builder,
        const pqxx::row& tuple);

    void dump(const Relation& relation);

    void dump(
        const Relation& relation,
        const std::string& idName,
        const StringMap& attributes = StringMap());

    void dump(
        const Relation& relation,
        DBID id,
        const StringMap& attributes = StringMap());

private:
    json::ArrayBuilder& builder_;
    const pqxx::row& tuple_;
};

} //maps
