#include "relations.h"
#include "magic_strings.h"

namespace maps {
namespace relation {

const struct Relation AD_CHILD =
    { category::AD, role::CHILD, category::AD, table::AD, RelationDirection::ToMaster };

const struct Relation AD_AD_SUBST_CHILD =
    { category::AD, role::AD_SUBST_CHILD, category::AD_SUBST, table::AD, RelationDirection::ToMaster };

const struct Relation AD_EXCLUSION =
    { category::AD, role::EXCLUSION, category::AD, table::AD, RelationDirection::ToSlave };

const struct Relation AD_SUBST_EXCLUSION =
    { category::AD_SUBST, role::EXCLUSION, category::AD, table::AD, RelationDirection::ToSlave };

const struct Relation AD_SUBST_SUBSTITUTION =
    { category::AD, role::SUBSTITUTION, category::AD_SUBST, table::AD, RelationDirection::ToMaster };

const struct Relation AD_CENTER =
    { category::AD, role::CENTER, category::AD_CNT, table::AD_CENTER, RelationDirection::ToSlave };

const struct Relation AD_PART =
    { category::AD, role::PART, category::AD_FC, table::AD_FACE, RelationDirection::ToSlave };

const struct Relation AD_SUBST_PART =
    { category::AD_SUBST, role::PART, category::AD_FC, table::AD_FACE_PATCH, RelationDirection::ToSlave };

const struct Relation AD_EL_START =
    { category::AD_EL, role::START, category::AD_JC, table::NODE, RelationDirection::ToSlave };

const struct Relation AD_EL_END =
    { category::AD_EL, role::END, category::AD_JC, table::NODE, RelationDirection::ToSlave };

const struct Relation AD_FC_PART =
    { category::AD_FC, role::PART, category::AD_EL, table::EDGE, RelationDirection::ToSlave };

const struct Relation AD_SUBST_FC_PART =
    { category::AD_SUBST_FC, role::PART, category::AD_EL, table::EDGE, RelationDirection::ToSlave };

const struct Relation AD_ADDR_ASSOCIATED_WITH =
    { category::AD, role::ADDR_ASSOCIATED_WITH, category::ADDR, table::AD, RelationDirection::ToMaster };

const struct Relation ADDR_ASSOCIATED_WITH_ZIPCODE =
    { category::ZIPCODE, role::ADDR_ASSOCIATED_WITH_ZIPCODE, category::ADDR, table::FT, RelationDirection::ToSlave };

const struct Relation RD_ASSOCIATED_WITH =
    { category::RD, role::ASSOCIATED_WITH, category::ADDR, table::RD, RelationDirection::ToMaster };

const struct Relation FT_ASSOCIATED_WITH =
    { category::FT, role::ASSOCIATED_WITH, category::ADDR, table::FT, RelationDirection::ToMaster };

const struct Relation COND_APPLIED_TO =
    { category::COND, role::APPLIED_TO, category::COND_DT, table::COND_DT, RelationDirection::ToSlave };

const struct Relation COND_FROM =
    { category::COND, role::FROM, category::RD_EL, table::RD_EL, RelationDirection::ToSlave };

const struct Relation COND_VIA =
    { category::COND, role::VIA, category::RD_JC, table::RD_JC, RelationDirection::ToSlave };

const struct Relation COND_TO =
    { category::COND, role::TO, category::RD_EL, table::RD_EL, RelationDirection::ToSlave };

const struct Relation RD_EL_START =
    { category::RD_EL, role::START, category::RD_JC, table::RD_JC, RelationDirection::ToSlave };

const struct Relation RD_EL_END =
    { category::RD_EL, role::END, category::RD_JC, table::RD_JC, RelationDirection::ToSlave };

const struct Relation RD_PART =
    { category::RD, role::PART, category::RD_EL, table::RD_EL, RelationDirection::ToSlave };

const struct Relation AD_ASSOCIATED_WITH =
    { category::AD, role::ASSOCIATED_WITH, category::RD, table::AD, RelationDirection::ToMaster };

const struct Relation MODEL3D_ASSOCIATED_WITH =
    { category::MODEL3D, role::ASSOCIATED_WITH, category::BLD, table::BLD, RelationDirection::ToSlave };

const struct Relation FT_FC_PART =
    { category::FT_FC, role::PART, category::FT_FC_EL, table::FACE, RelationDirection::ToMaster };

const struct Relation FT_LN_PART =
    { category::FT, role::PART, category::FT_LN_EL, table::FT, RelationDirection::ToMaster };

const struct Relation FT_LN_EL_START =
    { category::FT_LN_EL, role::START, category::FT_LN_JC, table::NODE, RelationDirection::ToSlave };

const struct Relation FT_LN_EL_END =
    { category::FT_LN_EL, role::END, category::FT_LN_JC, table::NODE, RelationDirection::ToSlave };

const struct Relation FT_FC_EL_START =
    { category::FT_FC_EL, role::START, category::FT_FC_JC, table::NODE, RelationDirection::ToSlave };

const struct Relation FT_FC_EL_END =
    { category::FT_FC_EL, role::END, category::FT_FC_JC, table::NODE, RelationDirection::ToSlave };

const struct Relation FT_FC_FC_PART =
    { category::FT, role::PART, category::FT_FC, table::FT, RelationDirection::ToMaster };

} // namespace relation
} // namespace maps
