#pragma once
#include "tables.h"

namespace maps {

enum class RelationDirection {
    ToMaster,
    ToSlave
};

struct Relation {
    std::string master;
    std::string role;
    std::string slave;
    const Table& toTable;
    RelationDirection direction;
};

namespace relation {

extern const struct Relation AD_CHILD;
extern const struct Relation AD_AD_SUBST_CHILD;
extern const struct Relation AD_EXCLUSION;
extern const struct Relation AD_SUBST_EXCLUSION;
extern const struct Relation AD_SUBST_SUBSTITUTION;
extern const struct Relation AD_CENTER;
extern const struct Relation AD_PART;
extern const struct Relation AD_SUBST_PART;
extern const struct Relation AD_EL_START;
extern const struct Relation AD_EL_END;
extern const struct Relation AD_FC_PART;
extern const struct Relation AD_SUBST_FC_PART;
extern const struct Relation AD_ADDR_ASSOCIATED_WITH;
extern const struct Relation ADDR_ASSOCIATED_WITH_ZIPCODE;
extern const struct Relation RD_ASSOCIATED_WITH;
extern const struct Relation FT_ASSOCIATED_WITH;
extern const struct Relation COND_APPLIED_TO;
extern const struct Relation COND_FROM;
extern const struct Relation COND_VIA;
extern const struct Relation COND_TO;
extern const struct Relation RD_EL_START;
extern const struct Relation RD_EL_END;
extern const struct Relation RD_PART;
extern const struct Relation AD_ASSOCIATED_WITH;
extern const struct Relation MODEL3D_ASSOCIATED_WITH;
extern const struct Relation FT_FC_PART;
extern const struct Relation FT_LN_PART;
extern const struct Relation FT_LN_EL_START;
extern const struct Relation FT_LN_EL_END;
extern const struct Relation FT_FC_EL_START;
extern const struct Relation FT_FC_EL_END;
extern const struct Relation FT_FC_FC_PART;

} // namespace relation
} // namespace maps
