#include "tables.h"
#include "magic_strings.h"

namespace maps {

const Table&
Table::base() const
{
    if (parentTable == nullptr) {
        return *this;
    }
    return parentTable->base();
}

namespace table {

namespace {
const std::string OBJECT_ID = "object_id";
const std::string SOURCE_ID = "import_source_id";
const std::string NONE = "";
} // namespace

const Table NODE          = { "node", "node_id", OBJECT_ID, NONE, nullptr };
const Table EDGE          = { "edge", "edge_id", OBJECT_ID, NONE, nullptr };
const Table FACE          = { "face", "face_id", OBJECT_ID, NONE, nullptr };
const Table FACE_EDGE     = { "face_edge", "edge_id", OBJECT_ID, NONE, &EDGE };

const Table AD            = { "ad", "ad_id", OBJECT_ID, SOURCE_ID, nullptr };
const Table AD_CENTER     = { "ad_center", "node_id", NONE, NONE, &NODE };
const Table AD_FACE       = { "ad_face", "face_id", NONE, NONE, &FACE };
const Table AD_FACE_PATCH = { "ad_face_patch", "face_id", NONE, NONE, &FACE};
const Table AD_NM         = { "ad_nm", "nm_id", OBJECT_ID, SOURCE_ID, nullptr };

const Table ADDR          = { "addr", "addr_id", OBJECT_ID, SOURCE_ID, nullptr};
const Table ADDR_NM       = { "addr_nm", "nm_id", OBJECT_ID, SOURCE_ID, nullptr};

const Table BLD           = { "bld", "bld_id", OBJECT_ID, SOURCE_ID, nullptr};
const Table MODEL3D       = { "model3d", "model3d_id", OBJECT_ID, SOURCE_ID, nullptr};

const Table META          = { "meta", "meta_id", NONE, NONE, nullptr};

const Table FT            = { "ft", "ft_id", OBJECT_ID, SOURCE_ID, nullptr};
const Table FT_CENTER     = { "ft_center", "node_id", NONE, NONE, &NODE };
const Table FT_EDGE       = { "ft_edge", "edge_id", NONE, NONE, &EDGE};
const Table FT_FACE       = { "ft_face", "face_id", NONE, NONE, &FACE };
const Table FT_NM         = { "ft_nm", "nm_id", OBJECT_ID, SOURCE_ID, nullptr };


const Table RD            = { "rd", "rd_id", OBJECT_ID, SOURCE_ID, nullptr };
const Table RD_EL         = { "rd_el", "rd_el_id", OBJECT_ID, SOURCE_ID, nullptr };
const Table RD_JC         = { "rd_jc", "rd_jc_id", OBJECT_ID, NONE, nullptr };
const Table RD_NM         = { "rd_nm", "nm_id", OBJECT_ID, SOURCE_ID, nullptr };
const Table COND          = { "cond", "cond_id", OBJECT_ID, NONE, nullptr };
const Table COND_DT       = { "cond_dt", "cond_dt_id", OBJECT_ID, NONE, nullptr };

} // namespace table
} // namespace maps
