#pragma once

#include "common.h"

#include <map>

namespace maps {

struct Table
{
    std::string name;
    std::string id;
    std::string objectId;
    std::string importSourceId;
    const Table* parentTable;

    const Table& base() const;
};

namespace table {

extern const Table NODE;
extern const Table EDGE;
extern const Table FACE;
extern const Table FACE_EDGE;

extern const Table AD;
extern const Table AD_CENTER;
extern const Table AD_FACE;
extern const Table AD_FACE_PATCH;
extern const Table AD_NM;

extern const Table ADDR;
extern const Table ADDR_NM;

extern const Table BLD;
extern const Table MODEL3D;

extern const Table META;

extern const Table FT;
extern const Table FT_CENTER;
extern const Table FT_EDGE;
extern const Table FT_FACE;
extern const Table FT_NM;


extern const Table RD;
extern const Table RD_EL;
extern const Table RD_JC;
extern const Table RD_NM;
extern const Table COND;
extern const Table COND_DT;

} // namespace table

} // namespace maps
