#include "../categories.h"
#include "../magic_strings.h"
#include "../attribute_dumper.h"

namespace maps {

namespace {
const std::string NODE_ID = "node_id";
} // namespace

struct AdCntCategory: public Category {
    std::string name() const override
    {
        return category::AD_CNT;
    }

    const Table& table() const override
    {
        return table::AD_CENTER;
    }

    std::string loadRowsSqlTemplate() const override
    {
        return "SELECT " + NODE_ID + " " + ID + ", " + "st_asgeojson(shape) " + SHAPE +
            " FROM node WHERE node_id IN %1%";
    }

    void tupleToJson(
        json::ObjectBuilder& builder,
        const pqxx::row& tuple) const override
    {
        builder[jkey::ATTRIBUTES] = [&](json::ObjectBuilder builder) {
            AttributeDumper ad(name(), builder);
            ad.dumpCategory();
        };
        dumpGeometry(builder, tuple);
    }
};

DEFINE_CATEGORY_OBJECT(AdCnt, AD_CNT);

} // namespace maps
