#include "../categories.h"
#include "../magic_strings.h"
#include "../attribute_dumper.h"

namespace maps {

struct AdJcCategory: public Category {
    std::string name() const override
    {
        return category::AD_JC;
    }

    const Table& table() const override
    {
        return table::NODE;
    }

    std::string loadIdsSql() const override
    {
        return "SELECT DISTINCT node.node_id FROM ad_face"
            " JOIN face_edge ON (face_edge.face_id = ad_face.face_id)"
            " JOIN edge ON (face_edge.edge_id = edge.edge_id)"
            " JOIN node ON (edge.f_node_id = node.node_id OR edge.t_node_id = node.node_id)";
    }

    std::string loadRowsSqlTemplate() const override
    {
        return "SELECT node_id " + ID + ", st_asgeojson(shape) " + SHAPE +
            " FROM node WHERE node_id IN %1%";
    }

    void tupleToJson(
        json::ObjectBuilder& builder,
        const pqxx::row& tuple) const override
    {
        builder[jkey::ATTRIBUTES] = [&](json::ObjectBuilder builder) {
            AttributeDumper ad(name(), builder);
            ad.dumpCategory();
        };
        dumpGeometry(builder, tuple);
    }

};

DEFINE_CATEGORY_OBJECT(AdJc, AD_JC);

} // namespace maps
