#include "common_nm.h"
#include "../categories.h"
#include "../magic_strings.h"

namespace maps {

namespace {
const std::string G_AD_ID = "g_ad_id";
} // namespace

struct AdNmCategory: public NmCategory {
    const Table& table() const override
    {
        return table::AD_NM;
    }

    const Table& masterTable() const override
    {
        return table::AD;
    }

    std::string masterCategory(const pqxx::row& tuple) const override
    {
        return tuple.at(G_AD_ID).is_null()
            ? category::AD
            : category::AD_SUBST;
    }

    std::string extraSqlFields() const override
    {
        return "(SELECT g_ad_id FROM ad WHERE ad.ad_id = ad_nm.ad_id) " + G_AD_ID;
    }
};

DEFINE_CATEGORY_OBJECT(AdNm, AD_NM);

}
