#include "../categories.h"
#include "../magic_strings.h"
#include "../attribute_dumper.h"
#include "../relation_dumper.h"
#include "../ft_helper.h"

namespace maps {

namespace {
const std::string ADDR_ID = "addr_id";
const std::string AD_ID = "ad_id";
const std::string RD_ID = "rd_id";
const std::string DISP_CLASS = "disp_class";
} // namespace


struct AddrCategory: public Category {
    const Table& table() const override
    {
        return table::ADDR;
    }

    std::string loadRowsSqlTemplate() const override
    {
        return "WITH paged_addr AS (SELECT * FROM addr WHERE addr_id IN %1%) "
            "SELECT"
            " paged_addr." + ADDR_ID + " " + ID + ","
            " paged_addr." + AD_ID + ","
            " paged_addr." + RD_ID + "," +
            ftSql("paged_addr.ft_id") + ","
            " paged_addr." + DISP_CLASS + ","
            " st_asgeojson(node.shape) " + SHAPE + " "
            "FROM paged_addr "
            "LEFT JOIN node ON (node.node_id = paged_addr.node_id)";
    }

    void tupleToJson(
        json::ObjectBuilder& builder,
        const pqxx::row& tuple) const override
    {
        builder[jkey::ATTRIBUTES] = [&](json::ObjectBuilder builder) {
            AttributeDumper ad(name(), builder);
            ad.dumpCategory();
            ad.dump<int>(DISP_CLASS, tuple);
        };

        dumpGeometry(builder, tuple);

        builder[jkey::RELATIONS] = [&](json::ArrayBuilder builder) {
            RelationDumper rd(builder, tuple);
            rd.dump(relation::AD_ADDR_ASSOCIATED_WITH);
            rd.dump(relation::RD_ASSOCIATED_WITH);

            //ft -> addr
            FtData ft(tuple);
            if (!ft.isNull()) {
                rd.dump(ft.relation(relation::FT_ASSOCIATED_WITH), ft.id());
            }
        };
    }
};

DEFINE_CATEGORY_OBJECT(Addr, ADDR);

} // namespace maps
