#pragma once

#include "../id_manager.h"
#include "../categories.h"

namespace maps {

struct NmCategory: public Category {
    virtual const Table& masterTable() const = 0;
    virtual std::string category(const pqxx::row&) const;
    virtual std::string masterCategory(const pqxx::row& tuple) const;

    virtual std::string extraSqlFields() const;

    virtual std::string loadRowsSqlTemplate() const;
    virtual void tupleToJson(
        json::ObjectBuilder& builder,
        const pqxx::row& tuple) const;
};

} //namespace maps
