#include "../categories.h"
#include "../magic_strings.h"
#include "../attribute_dumper.h"

namespace maps {

namespace {
const std::string COND_DT_ID = "cond_dt_id";
const std::string DATE_START = "date_start";
const std::string DATE_END = "date_end";
const std::string TIME_START = "time_start";
const std::string TIME_END = "time_end";
const std::string DAY = "day";
} // namespace

struct CondDtCategory: public Category {
    const Table& table() const override
    {
        return table::COND_DT;
    }

    std::string loadRowsSqlTemplate() const override
    {
        return "SELECT " +
            COND_DT_ID + " " + ID + ", " +
            DATE_START + ", " +
            DATE_END + ", " +
            TIME_START + ", " +
            TIME_END + ", " +
            DAY + " FROM cond_dt WHERE cond_dt_id in %1%";
    }

    void tupleToJson(
        json::ObjectBuilder& builder,
        const pqxx::row& tuple) const override
    {
        builder[jkey::ATTRIBUTES] = [&](json::ObjectBuilder builder) {
            AttributeDumper ad(name(), builder);
            ad.dumpCategory();
            ad.dump<std::string>(DATE_START, tuple);
            ad.dump<std::string>(DATE_END, tuple);
            ad.dump<std::string>(TIME_START, tuple);
            ad.dump<std::string>(TIME_END, tuple);
            ad.dump<int>(DAY, tuple);
        };
    }
};

DEFINE_CATEGORY_OBJECT(CondDt, COND_DT);

} // namespace maps
