#include "../categories.h"
#include "../magic_strings.h"
#include "../attribute_dumper.h"
#include "../relation_dumper.h"
#include "../ft_type.h"
#include "../ft_helper.h"

namespace {

const std::string FACE_ID = "face_id";
const std::string EDGE_IDS = "edge_ids";
const std::string IS_INTERIOR = "is_interior";

}

namespace maps {

struct FtFcCategory: public Category
{
    std::string name() const override
    {
        return category::FT_FC;
    }

    const Table& table() const override
    {
        return table::FT_FACE;
    }

    std::string loadIdsSql() const override
    {
        return
            "SELECT face_id FROM ft_face "
            "JOIN ft ON ft.ft_id=ft_face.ft_id "
            "WHERE ft_type_id NOT IN (" + polygonFtTypes() + ")";
    }

    std::string loadRowsSqlTemplate() const override
    {
        return
            "WITH paged_ft_face AS (SELECT * FROM ft_face WHERE face_id IN %1%) "
            "SELECT  face_id id, is_interior, " +
                ftMacroSql("paged_ft_face.ft_id") + " "
            "FROM paged_ft_face";
    }

    void tupleToJson(
    	json::ObjectBuilder& builder,
        const pqxx::row& tuple) const override
    {
        FtData ft(tuple);
        const std::string ftFcCategory = ft.category(category::FT_FC);

        builder[jkey::ATTRIBUTES] = [&](json::ObjectBuilder builder) {
            AttributeDumper ad(ftFcCategory, builder);
            ad.dumpCategory();
            ad.dump<bool>(IS_INTERIOR, tuple);
        };

        builder[jkey::RELATIONS] = [&](json::ArrayBuilder builder) {
            RelationDumper rd(builder, tuple);
            rd.dump(ft.relation(relation::FT_FC_FC_PART), ft.id());
        };
    }
};

DEFINE_CATEGORY_OBJECT(FtFc, FT_FC);

} // namespace maps
