#include "common_nm.h"
#include "../categories.h"
#include "../magic_strings.h"
#include "../ft_type.h"
#include "../ft_helper.h"

namespace maps {

struct FtNmCategory: public NmCategory {
    const Table& table() const override
    {
        return table::FT_NM;
    }

    const Table& masterTable() const override
    {
        return table::FT;
    }

    std::string extraSqlFields() const override
    {
        return ftSql("ft_nm.ft_id");
    }

    std::string category(const pqxx::row& tuple) const override
    {
        FtData ft(tuple);
        auto nmCategory = ft.category(category::FT_NM);
        REQUIRE(!nmCategory.empty(), "Oid " << ft.id() << " error: unsupported name for " << ft.category() << " : " << ft.ftType());
        return nmCategory;
    }

    std::string masterCategory(const pqxx::row& tuple) const override
    {
        FtData ft(tuple);
        return ft.category(category::FT);
    }
};

DEFINE_CATEGORY_OBJECT(FtNm, FT_NM);

} // namespace maps
