#include "../categories.h"
#include "../magic_strings.h"
#include "../attribute_dumper.h"
#include "../relation_dumper.h"
#include "../ft_type.h"

namespace maps {

namespace {
const std::string MODEL3D_ID = "model3d_id";
const std::string KMZ = "kmz";
const std::string BLD_ID = "bld_id";
} // namespace

struct Model3dCategory: public Category {
    const Table& table() const override
    {
        return table::MODEL3D;
    }

    std::string loadRowsSqlTemplate() const override {
        return "WITH paged_model AS (SELECT * FROM model3d WHERE model3d_id IN %1%) "
            "SELECT"
            " paged_model." + MODEL3D_ID + " " + ID + "," +
            " encode(paged_model.kmz, 'base64') " + KMZ + "," +
            " bld. " + BLD_ID + " "
            "FROM paged_model "
            "LEFT JOIN bld ON (bld.model3d_id = paged_model.model3d_id) ";
    }

    void tupleToJson(
        json::ObjectBuilder& builder,
        const pqxx::row& tuple) const override
    {
        builder[jkey::ATTRIBUTES] = [&](json::ObjectBuilder builder) {
            AttributeDumper ad(name(), builder);
            ad.dumpCategory();
        };

        builder[jkey::DESCRIPTION] = tuple.at(KMZ).as<std::string>();

        if (!tuple.at(BLD_ID).is_null()) {
            builder[jkey::RELATIONS] = [&](json::ArrayBuilder builder) {
                RelationDumper rd(builder, tuple);
                rd.dump(relation::MODEL3D_ASSOCIATED_WITH);
            };
        }
    }
};

DEFINE_CATEGORY_OBJECT(Model3d, MODEL3D);

} // namespace maps
