#include "../common.h"
#include "../categories.h"
#include "../magic_strings.h"
#include "../attribute_dumper.h"

namespace maps {

namespace {
const std::string RD_JC_ID = "rd_jc_id";
const std::string BOUND_JC = "bound_jc";
const std::string IS_BOUND = "is_bound";
} // namespace

struct RdJcCategory: public Category {
    const Table& table() const override
    {
        return table::RD_JC;
    }

    std::string loadRowsSqlTemplate() const override
    {
        return "SELECT rd_jc." + RD_JC_ID + " " + ID + ", " +
            " st_asgeojson(shape) " + SHAPE + ", " +
            " bound_jc.rd_jc_id IS NOT NULL " + IS_BOUND + " "
            "FROM rd_jc "
            "LEFT JOIN bound_jc on bound_jc.rd_jc_id = rd_jc.rd_jc_id "
            "WHERE rd_jc.rd_jc_id IN %1%";
    }

    void tupleToJson(
        json::ObjectBuilder& builder,
        const pqxx::row& tuple) const override
    {
        builder[jkey::ATTRIBUTES] = [&](json::ObjectBuilder builder) {
            AttributeDumper ad(name(), builder);
            ad.dumpCategory();
            if (tuple.at(IS_BOUND).as<bool>())
                ad.dumpCategory(BOUND_JC);
        };
        dumpGeometry(builder, tuple);
    }
};

DEFINE_CATEGORY_OBJECT(RdJc, RD_JC);

} // namespace maps
