from maps.wikimap.stat.arm.actions_count.lib import eval_report

from nile.api.v1 import (
    cli,
    datetime as nd,
)
from datetime import timedelta


@cli.statinfra_job
def make_job(
    job,
    options,
    statface_client
):
    current_date = nd.Datetime.from_iso(options.dates[0])
    previous_date = current_date - timedelta(days=1)
    dump_date_string = str(previous_date.date())

    eval_report.make_job(
        job, [previous_date], statface_client, dump_date_string
    )
    return job


if __name__ == '__main__':
    cli.run()
