from maps.wikimap.stat.arm.actions_count.lib.eval_report import (
    make_job,
    make_testable_job,
)
from nile.api.v1 import (
    clusters,
    datetime as nd,
    statface as ns,
    local as nl,
    Record,
)


def test_smoke():
    cluster = clusters.MockCluster()
    job = cluster.job()
    make_job(
        job,
        list(nd.date_range('2019-10-01', '2019-10-01', step=1, stringify=False)),
        ns.StatfaceBetaClient(),
        '2019-10-01',
    )
    job.local_run(
        sources={},
        sinks={},
    )


def test_add_fiedldate():
    cluster = clusters.MockCluster()
    job = cluster.job()
    make_testable_job(
        job,
        list(nd.date_range('2019-10-26', '2019-10-30', step=1, stringify=False)),
        'not used date-string'
    )
    actions_input = [Record(
        modified_at=1572367355,  # Вт окт 29 19:42:35 MSK 2019
        object_id=16105,
        object_type='closure',
        operation_type='create',
        user_login='robot-maps-arm',
        user_role='expert',
        version=0,
    )]
    output = []
    job.local_run(
        sources={'actions': nl.StreamSource(actions_input)},
        sinks={'actions_fd': nl.ListSink(output)},
    )
    correct = [Record(
        fielddate='2019-10-29',
        object_id=16105,
        object_type='closure',
        operation_type='create',
        user_login='robot-maps-arm',
        user_role='expert',
        version=0,
    )]

    assert output == correct


def test_convert_operations():
    cluster = clusters.MockCluster()
    job = cluster.job()
    make_testable_job(
        job,
        list(nd.date_range('2019-10-26', '2019-10-30', step=1, stringify=False)),
        'not used date-string'
    )
    actions_input = [Record(
        modified_at=1572367355,  # Вт окт 29 19:42:35 MSK 2019
        object_id=16105,
        object_type='closure',
        operation_type='time'.encode('utf-8'),
        user_login='robot-maps-arm',
        user_role='expert',
        version=0,
    )]
    output = []
    job.local_run(
        sources={'actions': nl.StreamSource(actions_input)},
        sinks={'actions_fd_op': nl.ListSink(output)},
    )
    correct = [
        Record(
            fielddate='2019-10-29',
            object_id=16105,
            object_type='closure',
            operation_type=op,
            user_login='robot-maps-arm',
            user_role='expert',
            version=0,
        ) for op in ['\t_total_\t', '\t_total_\tmodify\t', '\t_total_\tmodify\ttime\t']
    ]

    assert output == correct


def test_convert_operations_other():
    cluster = clusters.MockCluster()
    job = cluster.job()
    make_testable_job(
        job,
        list(nd.date_range('2019-10-26', '2019-10-30', step=1, stringify=False)),
        'not used date-string'
    )
    actions_input = [Record(
        modified_at=1572367355,  # Вт окт 29 19:42:35 MSK 2019
        object_id=16105,
        object_type='closure',
        operation_type='unimportant_action_1 unimportant_action_2'.encode('utf-8'),
        user_login='robot-maps-arm',
        user_role='expert',
        version=0,
    )]
    output = []
    job.local_run(
        sources={'actions': nl.StreamSource(actions_input)},
        sinks={'actions_fd_op': nl.ListSink(output)},
    )
    correct = [
        Record(
            fielddate='2019-10-29',
            object_id=16105,
            object_type='closure',
            operation_type=op,
            user_login='robot-maps-arm',
            user_role='expert',
            version=0,
        ) for op in ['\t_total_\t', '\t_total_\tmodify\t', '\t_total_\tmodify\t_other_\t']
    ]

    assert output == correct


def test_join_regions():
    cluster = clusters.MockCluster()
    job = cluster.job()
    make_testable_job(
        job,
        list(nd.date_range('2019-10-26', '2019-10-30', step=1, stringify=False)),
        'not used date-string'
    )
    actions_input = [Record(
        fielddate='2019-10-29',
        object_id=16105,
        object_type='closure',
        operation_type='\t_total_\t',
        user_login='robot-maps-arm'.encode('utf-8'),
        user_role='expert'.encode('utf-8'),
        version=0,
    )]
    objects_input = [Record(
        object_id=16105,
        object_type='closure',
        region_id='103544',
        template_id=444,
        category='no-transit'.encode('utf-8'),
        fake=False,
    )]
    regions = [
        Record(
            region_tree='\t10\t',
            region_id='103544',
        ),
    ]
    output = []
    job.local_run(
        sources={
            'actions_fd_op': nl.StreamSource(actions_input),
            'objects': nl.StreamSource(objects_input),
            'regions': nl.StreamSource(regions),
        },
        sinks={'actions_fb_op_user_region': nl.ListSink(output)},
    )
    correct = [
        Record(
            fielddate='2019-10-29',
            object_type='closure',
            operation_type='\t_total_\t',
            user=user,
            region='\t10\t',
            version=0,
            template_id=444,
            category='no-transit'.encode('utf-8'),
            fake=False,
        ) for user in ['\t_total_\t', '\t_total_\tuser\t', '\t_total_\tuser\trobot-maps-arm\t']
    ]
    assert output == correct


def test_unknown_regions():
    cluster = clusters.MockCluster()
    job = cluster.job()
    make_testable_job(
        job,
        list(nd.date_range('2019-10-26', '2019-10-30', step=1, stringify=False)),
        'not used date-string'
    )
    actions_input = [Record(
        fielddate='2019-10-29',
        object_id=16105,
        object_type='closure',
        operation_type='\t_total_\t',
        user_login='wikimaps'.encode('utf-8'),
        user_role='expert'.encode('utf-8'),
        version=0,
    )]
    objects_input = [Record(
        object_id=16105,
        object_type='closure',
        region_id='---',
        template_id=444,
        category='no-transit'.encode('utf-8'),
        fake=False,
    )]
    regions = [
        Record(
            region_tree='\t10\t',
            region_id='103544',
        ),
    ]
    output = []
    job.local_run(
        sources={
            'actions_fd_op': nl.StreamSource(actions_input),
            'objects': nl.StreamSource(objects_input),
            'regions': nl.StreamSource(regions),
        },
        sinks={'actions_fb_op_user_region': nl.ListSink(output)},
    )
    correct = [
        Record(
            fielddate='2019-10-29',
            object_type='closure',
            operation_type='\t_total_\t',
            user=user,
            region=region,
            version=0,
            template_id=444,
            category='no-transit'.encode('utf-8'),
            fake=False,
        ) for user in ['\t_total_\t', '\t_total_\trobot\t', '\t_total_\trobot\twikimaps\t']
        for region in ['\t10000\t', '\t10000\t_unknown_\t']
    ]
    assert output == correct


def test_count():
    cluster = clusters.MockCluster()
    job = cluster.job()
    make_testable_job(
        job,
        list(nd.date_range('2019-10-26', '2019-10-30', step=1, stringify=False)),
        'not used date-string'
    )
    actions_input = [
        Record(
            fielddate='2019-10-29',
            object_type='closure'.encode('utf-8'),
            operation_type='\t_total_\t',
            user='\t_total_\t',
            region='\t10\t',
            version=0,
            template_id=444,
            category='no-transit'.encode('utf-8'),
            fake=False,
        ),
        Record(
            fielddate='2019-10-29',
            object_type='closure'.encode('utf-8'),
            operation_type='\t_total_\t',
            user='\t_total_\t',
            region='\t10\t',
            version=0,
            template_id=None,
            category='no-transit'.encode('utf-8'),
            fake=False,
        ),
    ]
    output = []
    job.local_run(
        sources={'actions_fb_op_user_region': nl.StreamSource(actions_input)},
        sinks={'actions_count': nl.ListSink(output)},
    )
    correct = [
        Record(count=2, fielddate='2019-10-29', object_type='\t_total_\t',
               operation_type='\t_total_\t', region='\t10\t', user='\t_total_\t'),
        Record(count=2, fielddate='2019-10-29', object_type='\t_total_\tclosure\t',
               operation_type='\t_total_\t', region='\t10\t', user='\t_total_\t'),
        Record(count=1, fielddate='2019-10-29', object_type='\t_total_\tclosure\tno-transit\t',
               operation_type='\t_total_\t', region='\t10\t', user='\t_total_\t'),
        Record(count=1, fielddate='2019-10-29', object_type='\t_total_\tclosure\ttemplate-no-transit\t',
               operation_type='\t_total_\t', region='\t10\t', user='\t_total_\t'),
    ]

    assert output == correct
