from typing import (
    List
)
from nile.api.v1 import (
    Record,
)


'''
    Example:
    ['_total_', 'robot', 'robot-maps-arm']
    converts to
    [
        '\t_total_\t',
        '\t_total_\trobot\t',
        '\t_total_\trobot\trobot-maps-arm\t',
    ]
'''


def list_to_tree(string_list: List[str]) -> List[str]:
    output = []
    separator = '\t'

    if len(string_list) > 0:
        output.append(separator + string_list[0] + separator)
        for input_el in string_list[1:]:
            output.append(output[-1] + input_el + separator)

    return output


def fix_unknown_regions(rows):
    EARTH_REGION_ID = '10000'
    for row in rows:
        if row.region is None:
            for region_string in list_to_tree([EARTH_REGION_ID, '_unknown_']):
                yield Record(row, region=region_string)
        else:
            yield row
