from maps.wikimap.stat.arm.objects_count.lib import eval_report

from nile.api.v1 import (
    clusters,
    datetime as nd,
    statface as ns
)

import argparse


def main() -> None:
    parser = argparse.ArgumentParser(
        description="Use environment variables 'YT_TOKEN' and 'STATFACE_TOKEN' for OAuth authorisation."
    )

    parser.add_argument(
        '--from-date',
        help='Begin date, iso format: 2018-12-31',
        required=True
    )
    parser.add_argument(
        '--to-date',
        help='End date, iso format: 2018-12-31',
        required=True
    )
    parser.add_argument(
        '--dump-date',
        help='YT dump-tables date suffix, iso format: 2018-12-31',
        required=True
    )
    parser.add_argument(
        '--prod',
        help='Upload to production Statface',
        action='store_true'
    )

    args = parser.parse_args()

    if args.prod:
        statface_client = ns.StatfaceProductionClient()
    else:
        statface_client = ns.StatfaceBetaClient()

    start_date = nd.Datetime.from_iso(args.from_date)
    end_date = nd.Datetime.from_iso(args.to_date)
    if start_date > end_date:
        raise RuntimeError('begin date > end date')

    dates = list(nd.date_range(start_date, end_date, step=1, stringify=False))

    hahn_cluster = clusters.yt.Hahn()

    job = hahn_cluster.job("arm_aggregator")
    eval_report.make_job(
        job, dates, statface_client, args.dump_date
    )
    job.run()


if __name__ == '__main__':
    main()
