from maps.wikimap.stat.arm_dump_to_yt.logger import logger


def dump_to_yt(
    yt_client,
    db_engine,
    table_path,
    query,
    table_schema,
    row_mapper=None,
):
    def exact_row_mapper(row):
        return row

    if row_mapper is None:
        row_mapper = exact_row_mapper

    logger.info("Selecting data from database")

    result_set = db_engine.execute(query)
    records = map(lambda row: dict(row.items()), result_set)
    records_mapped = map(row_mapper, records)

    logger.info("Result set rows: {}".format(result_set.rowcount))

    logger.info(
        "Writing data to YT path '{}'".format(table_path)
    )

    yt_client.create(
        "table",
        table_path,
        ignore_existing=True,
        recursive=True,
        attributes={"schema": table_schema}
    )

    yt_client.write_table(
        table_path,
        records_mapped
    )
