from maps.wikimap.stat.libs.common.lib import geobase_region as gb


"""
    Add 'region_id' key
    with value computed from 'lon' && 'lat'.
"""


def add_region(row):
    region_id = gb.geobase_region_id(row['lon'], row['lat'])
    try:
        region = gb.lookup().get_region_by_id(region_id)
        region_name = region['en_name']
    except:
        region_name = 'not found'
    row['region_id'] = str(region_id)
    row['region_name'] = region_name
    return row
