from maps.wikimap.stat.libs.nile_utils import (
    get_tables_with_names,
    put_tables_by_prefixes,
)
from maps.wikimap.stat.assessment.libs.date_utils import (
    MAX_GRADE_DELAY_DAYS,
    extend_with_prior_days,
)
from maps.wikimap.stat.assessment.datasets.fixed_units.lib.dataset import (
    DATASET_SCHEMA,
    make_dataset,
)
from nile.api.v1 import cli

_MIN_ACTION_DATE_FOR_FIX = '2022-07-05'
_MAX_FIX_DELAY_DAYS = 7


@cli.statinfra_job(options=[
    cli.Option(
        'recalc-prior-days',
        default=MAX_GRADE_DELAY_DAYS + _MAX_FIX_DELAY_DAYS,
        help=f'Also recalculate for dates prior to specified. Defaults to {MAX_GRADE_DELAY_DAYS + _MAX_FIX_DELAY_DAYS}.',
   ),
])
def make_job(job, options):
    dates = extend_with_prior_days(options.dates, int(options.recalc_prior_days))
    dates = list(filter(lambda date: date >= _MIN_ACTION_DATE_FOR_FIX, dates))

    make_dataset(
        min(dates), max(dates),
        job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_unit'),
        get_tables_with_names(
            job,
            '//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/puid_info/',
            'date', dates,
        )
    ).call(
        put_tables_by_prefixes,
        '//home/maps/core/nmaps/analytics/assessment/datasets/fixed_units/',
        'date', dates,
        DATASET_SCHEMA,
    )

    return job


def main():
    cli.run()
