from maps.wikimap.stat.assessment.graded_units_log.lib.feedback import (
    get_feedback_tasks,
    add_task_id_region_id,
)
from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record
from cyson import UInt
import pytest


def test_should_get_feedback_tasks():
    result = nile_ut.yql_run(
        get_feedback_tasks,
        feedback_task_table=nile_ut.Table([
            Record(id=UInt(1), created_at='2021-07-07suffix', position='pos1', source=b'source1', type=b'type1', test_column='test1'),
            Record(id=UInt(2), created_at='2021-07-08suffix', position='pos2', source=b'source2', type=b'type2', test_column='test2'),
            Record(id=UInt(3), created_at='2021-07-09suffix', position='pos3', source=b'source3', type=b'type3', test_column='test3'),
        ]),
        min_created_date='2021-07-08',
    )
    assert([
        Record(entity_id=2, position='pos2', source=b'source2', type=b'type2'),
        Record(entity_id=3, position='pos3', source=b'source3', type=b'type3'),
    ]) == sorted(result)


@pytest.fixture
def geobase_mock(monkeypatch):
    PATCHED_MODULE = 'maps.wikimap.stat.assessment.graded_units_log.lib.feedback.'
    monkeypatch.setattr(PATCHED_MODULE + 'lon_lat_position_to_region_id', int)
    monkeypatch.setattr(PATCHED_MODULE + 'GEOBASE_FILES', [])


def test_should_get_feedback_log(geobase_mock):
    result = nile_ut.yql_run(
        add_task_id_region_id,
        graded_units=nile_ut.Table([
            Record(entity_id='1', entity_domain='feedback', action='accept',    test_column='test1'),
            Record(entity_id='2', entity_domain='feedback', action='need-info', test_column='test2'),
        ]),
        feedback_tasks=nile_ut.Table([
            Record(entity_id=1, position='101', source=b'source1', type=b'type1'),
            Record(entity_id=2, position='102', source=b'source2', type=b'type2'),
        ]),
    )
    assert sorted([
        Record(entity_id='1', entity_domain='feedback', action='accept',    region_id=101, task_id='feedback/accept/source1/type1',  test_column='test1'),
        Record(entity_id='2', entity_domain='feedback', action='need-info', region_id=102, task_id='feedback/need-info/source2/type2', test_column='test2'),
    ]) == sorted(result)
