from maps.wikimap.stat.assessment.graded_units_log.lib.graded_units_log import _get_graded_units
from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record


def test_should_filter_out_units_without_grades():
    result = nile_ut.yql_run(
        _get_graded_units,
        unit_table=nile_ut.Table([
            Record(unit_id=1, action_at='2021-07-09suffix', payload_column='payload-1'),
        ]),
        grade_table=nile_ut.Table([
            Record(unit_id=2, graded_at='2021-07-09suffix', value=b'correct', qualification='basic', test_column='test-1'),
        ]),
        min_date='2021-07-09',
    )
    assert [] == result


def test_should_filter_out_units_older_than_min_date():
    result = nile_ut.yql_run(
        _get_graded_units,
        unit_table=nile_ut.Table([
            Record(unit_id=1, action_at='2021-07-08suffix', payload_column='payload-1'),
        ]),
        grade_table=nile_ut.Table([
            Record(unit_id=1, graded_at='2021-07-09suffix', value=b'correct', qualification='basic', test_column='test-1'),
        ]),
        min_date='2021-07-09',
    )
    assert [] == result


def test_should_get_last_arbitrary_grade():
    result = nile_ut.yql_run(
        _get_graded_units,
        unit_table=nile_ut.Table([
            Record(
                unit_id=1,
                entity_id='101',
                entity_domain='domain1',
                action_by=1001,
                action_at='2021-07-09suffix',
                action='action1',
            ),
        ]),
        grade_table=nile_ut.Table([
            # it's easier to infer schema from dummy record:
            Record(unit_id=0, graded_at='2021-07-09suffix',  value=b'val',       qualification='qual', test_column='test-0'),

            Record(unit_id=1, graded_at='2021-07-09suffix1', value=b'correct',   qualification=None,   test_column='test-1'),
            Record(unit_id=1, graded_at='2021-07-09suffix2', value=b'incorrect', qualification=None,   test_column='test-2'),
        ]),
        min_date='2021-07-09',
    )
    assert sorted([
        Record(
            unit_id=1,
            entity_id='101',
            entity_domain='domain1',
            action_by=1001,
            action_at='2021-07-09suffix',
            action='action1',
            value='incorrect',
            certainty='arbitrary',
        ),
    ]) == sorted(result)


def test_should_prioritize_basic_grades_balance_over_arbitrary_grades():
    result = nile_ut.yql_run(
        _get_graded_units,
        unit_table=nile_ut.Table([
            Record(
                unit_id=1,
                entity_id='101',
                entity_domain='domain1',
                action_by=1001,
                action_at='2021-07-09suffix',
                action='action1',
            ),
            Record(
                unit_id=2,
                entity_id='102',
                entity_domain='domain2',
                action_by=1002,
                action_at='2021-07-10suffix',
                action='action2',
            ),
            Record(
                unit_id=3,
                entity_id='103',
                entity_domain='domain3',
                action_by=1003,
                action_at='2021-07-11suffix',
                action='action3',
            ),
            Record(
                unit_id=4,
                entity_id='104',
                entity_domain='domain4',
                action_by=1004,
                action_at='2021-07-12suffix',
                action='action4',
            ),
        ]),
        grade_table=nile_ut.Table([
            Record(unit_id=1, graded_at='2021-07-09suffix1', value=b'correct',   qualification='basic', test_column='test-1'),
            Record(unit_id=1, graded_at='2021-07-09suffix2', value=b'incorrect', qualification='basic', test_column='test-2'),
            Record(unit_id=1, graded_at='2021-07-10suffix1', value=b'correct',   qualification='basic', test_column='test-3'),
            Record(unit_id=1, graded_at='2021-07-10suffix2', value=b'correct',   qualification=None,    test_column='test-4'),

            Record(unit_id=2, graded_at='2021-07-10suffix1', value=b'correct',   qualification=None,    test_column='test-5'),
            Record(unit_id=2, graded_at='2021-07-10suffix2', value=b'correct',   qualification='basic', test_column='test-6'),
            Record(unit_id=2, graded_at='2021-07-10suffix3', value=b'incorrect', qualification='basic', test_column='test-7'),

            Record(unit_id=3, graded_at='2021-07-11suffix1', value=b'incorrect', qualification='basic', test_column='test-8'),

            Record(unit_id=4, graded_at='2021-07-12suffix1', value=b'correct',   qualification='basic', test_column='test-9'),
            Record(unit_id=4, graded_at='2021-07-12suffix2', value=b'correct',   qualification='basic', test_column='test-10'),
        ]),
        min_date='2021-07-09',
    )
    assert sorted([
        Record(
            unit_id=1,
            entity_id='101',
            entity_domain='domain1',
            action_by=1001,
            action_at='2021-07-09suffix',
            action='action1',
            value='correct',
            certainty='basic_majority',
        ),
        Record(
            unit_id=2,
            entity_id='102',
            entity_domain='domain2',
            action_by=1002,
            action_at='2021-07-10suffix',
            action='action2',
            value='conflict',
            certainty='basic_majority',
        ),
        Record(
            unit_id=3,
            entity_id='103',
            entity_domain='domain3',
            action_by=1003,
            action_at='2021-07-11suffix',
            action='action3',
            value='incorrect',
            certainty='basic_single',
        ),
        Record(
            unit_id=4,
            entity_id='104',
            entity_domain='domain4',
            action_by=1004,
            action_at='2021-07-12suffix',
            action='action4',
            value='correct',
            certainty='basic_unanimous',
        )
    ]) == sorted(result)


def test_should_prioritize_last_expert_grade_over_other_grades():
    result = nile_ut.yql_run(
        _get_graded_units,
        unit_table=nile_ut.Table([
            Record(
                unit_id=1,
                entity_id='101',
                entity_domain='domain1',
                action_by=1001,
                action_at='2021-07-09suffix',
                action='action1',
            ),
        ]),
        grade_table=nile_ut.Table([
            Record(unit_id=1, graded_at='2021-07-09suffix1', value=b'correct',   qualification='basic',  test_column='test-1'),
            Record(unit_id=1, graded_at='2021-07-09suffix2', value=b'correct',   qualification='basic',  test_column='test-2'),
            Record(unit_id=1, graded_at='2021-07-10suffix1', value=b'correct',   qualification='expert', test_column='test-3'),
            Record(unit_id=1, graded_at='2021-07-10suffix2', value=b'incorrect', qualification='expert', test_column='test-4'),
            Record(unit_id=1, graded_at='2021-07-11suffix1', value=b'correct',   qualification='basic',  test_column='test-5'),
            Record(unit_id=1, graded_at='2021-07-11suffix2', value=b'correct',   qualification=None,     test_column='test-6'),
        ]),
        min_date='2021-07-09',
    )
    assert sorted([
        Record(
            unit_id=1,
            entity_id='101',
            entity_domain='domain1',
            action_by=1001,
            action_at='2021-07-09suffix',
            action='action1',
            value='incorrect',
            certainty='expert',
        ),
    ]) == sorted(result)
