from maps.wikimap.stat.assessment.libs.date_utils import (
    MAX_GRADE_DELAY_DAYS,
    extend_with_prior_days,
)
from maps.wikimap.stat.assessment.graded_units_log.lib.graded_units_log import (
    make_graded_units_log,
    GRADED_UNITS_LOG_SCHEMA,
)
from maps.wikimap.stat.libs.nile_utils import put_tables_by_prefixes
from nile.api.v1 import cli


@cli.statinfra_job(options=[
    cli.Option(
        'recalc-prior-days',
        default=MAX_GRADE_DELAY_DAYS,
        help=f'Also recalculate for dates prior to specified. Defaults to {MAX_GRADE_DELAY_DAYS}.',
    ),
])
def make_job(job, options):
    unit_dates = extend_with_prior_days(options.dates, int(options.recalc_prior_days))

    make_graded_units_log(
        job,
        dates=unit_dates,
        grade_table=job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_grade'),
        unit_table=job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_unit'),
        social_task_table=job.concat(
            job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_active'),
            job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_closed'),
        ),
        commit_event_table=job.table('//home/maps/core/nmaps/dynamic/replica/social/social_commit_event'),
        feedback_task_table=job.table('//home/maps/core/nmaps/analytics/feedback/db/feedback_latest'),
        components_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/components'),
        issue_events_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/issue_events'),
        issues_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/issues'),
        resolutions_table=job.table('//home/startrek/tables/prod/yandex-team/common/resolutions'),
        statuses_table=job.table('//home/startrek/tables/prod/yandex-team/common/statuses'),
    ).call(
        put_tables_by_prefixes,
        '//home/maps/core/nmaps/analytics/assessment/graded_units_log/',
        'action_at', unit_dates,
        GRADED_UNITS_LOG_SCHEMA,
    )

    return job


def main():
    cli.run()
