from maps.wikimap.stat.assessment.grades_dataset.lib.tree_dimensions import (
    graded_by_to_graded_by_tree,
    region_id_to_region_name_tree,
    task_id_to_task_name_tree,
)
from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record
from cyson import UInt


def test_should_convert_region_id_to_region_name_tree():
    result = nile_ut.yql_run(
        region_id_to_region_name_tree,
        stream=nile_ut.Table([
            Record(region_id=1, test_column1=91),
            Record(region_id=3, test_column1=93),
        ]),
        major_regions_map=nile_ut.Table([
            Record(region_id=1, region_name='\tЗемля\t',                      test_column2=911),
            Record(region_id=1, region_name='\tЗемля\tРегион1\t',             test_column2=912),
            Record(region_id=1, region_name='\tЗемля\tРегион1\tПодрегион1\t', test_column2=913),

            Record(region_id=2, region_name='\tЗемля\t',                      test_column2=921),
            Record(region_id=2, region_name='\tЗемля\tРегион2\t',             test_column2=922),
            Record(region_id=2, region_name='\tЗемля\tРегион2\tПодрегион2\t', test_column2=923),
        ]),
    )
    assert sorted([
        Record(region_name_tree='\tЗемля\t',                      test_column1=91),
        Record(region_name_tree='\tЗемля\tРегион1\t',             test_column1=91),
        Record(region_name_tree='\tЗемля\tРегион1\tПодрегион1\t', test_column1=91),

        Record(region_name_tree='\tЗемля\t', test_column1=93),
    ]) == sorted(result)


def test_should_convert_graded_by_to_graded_by_tree():
    result = nile_ut.yql_run(
        graded_by_to_graded_by_tree,
        stream=nile_ut.Table([
            Record(graded_by=1, test_column=91),
            Record(graded_by=3, test_column=93),
        ]),
        puid_map=nile_ut.Table([
            Record(puid=UInt(1), puid_tree=b'\tall\t'),
            Record(puid=UInt(1), puid_tree=b'\tall\tcategory1\t'),
            Record(puid=UInt(1), puid_tree=b'\tall\tcategory1\tuser1\t'),

            Record(puid=UInt(2), puid_tree=b'\tall\t'),
            Record(puid=UInt(2), puid_tree=b'\tall\tcategory3\t'),
            Record(puid=UInt(2), puid_tree=b'\tall\tcategory3\tuser3\t'),
        ]),
    )
    assert sorted([
        Record(graded_by_tree='\tall\t',                   test_column=91),
        Record(graded_by_tree='\tall\tcategory1\t',        test_column=91),
        Record(graded_by_tree='\tall\tcategory1\tuser1\t', test_column=91),

        Record(graded_by_tree='\tall\t',             test_column=93),
        Record(graded_by_tree='\tall\tunknown\t',    test_column=93),
        Record(graded_by_tree='\tall\tunknown\t3\t', test_column=93),
    ]) == sorted(result)


def test_should_task_id_to_task_name_tree():
    result = nile_ut.yql_run(
        task_id_to_task_name_tree,
        stream=nile_ut.Table([
            Record(action_date='date1', task_id='task_id1', test_column1=91),
            Record(action_date='date1', task_id='task_id2', test_column1=92),
            Record(action_date='date1', task_id='task_id3', test_column1=93),

            Record(action_date='date2', task_id='task_id1', test_column1=94),
            Record(action_date='date2', task_id='task_id2', test_column1=95),
        ]),
        tariffs_with_dates=nile_ut.Table([
            Record(date='date1', task_id='task_id1', task_name_tree='\tall\t',                          test_column2=901),
            Record(date='date1', task_id='task_id1', task_name_tree='\tall\ttask_category11\t',         test_column2=902),
            Record(date='date1', task_id='task_id1', task_name_tree='\tall\ttask_category11\ttask11\t', test_column2=903),

            Record(date='date1', task_id='task_id2', task_name_tree='\tall\t',                          test_column2=904),
            Record(date='date1', task_id='task_id2', task_name_tree='\tall\ttask_category12\t',         test_column2=905),
            Record(date='date1', task_id='task_id2', task_name_tree='\tall\ttask_category12\ttask12\t', test_column2=906),

            Record(date='date2', task_id='task_id1', task_name_tree='\tall\t',                          test_column2=907),
            Record(date='date2', task_id='task_id1', task_name_tree='\tall\ttask_category21\t',         test_column2=908),
            Record(date='date2', task_id='task_id1', task_name_tree='\tall\ttask_category21\ttask21\t', test_column2=909),

            Record(date='date2', task_id='task_id3', task_name_tree='\tall\t',                          test_column2=910),
            Record(date='date2', task_id='task_id3', task_name_tree='\tall\ttask_category23\t',         test_column2=911),
            Record(date='date2', task_id='task_id3', task_name_tree='\tall\ttask_category23\ttask23\t', test_column2=912),
        ]),
    )
    assert sorted([
        Record(task_name_tree='\tall\t',                          test_column1=91),
        Record(task_name_tree='\tall\ttask_category11\t',         test_column1=91),
        Record(task_name_tree='\tall\ttask_category11\ttask11\t', test_column1=91),

        Record(task_name_tree='\tall\t',                          test_column1=92),
        Record(task_name_tree='\tall\ttask_category12\t',         test_column1=92),
        Record(task_name_tree='\tall\ttask_category12\ttask12\t', test_column1=92),

        Record(task_name_tree='\tall\t',                    test_column1=93),
        Record(task_name_tree='\tall\tunknown\t',           test_column1=93),
        Record(task_name_tree='\tall\tunknown\ttask_id3\t', test_column1=93),

        Record(task_name_tree='\tall\t',                          test_column1=94),
        Record(task_name_tree='\tall\ttask_category21\t',         test_column1=94),
        Record(task_name_tree='\tall\ttask_category21\ttask21\t', test_column1=94),

        Record(task_name_tree='\tall\t',                    test_column1=95),
        Record(task_name_tree='\tall\tunknown\t',           test_column1=95),
        Record(task_name_tree='\tall\tunknown\ttask_id2\t', test_column1=95),
    ]) == sorted(result)
