from maps.wikimap.stat.libs.nile_utils import (
    get_tables_with_names,
    put_tables_by_prefixes,
)
from maps.wikimap.stat.assessment.libs.date_utils import (
    MAX_GRADE_DELAY_DAYS,
    extend_with_prior_days,
)
from maps.wikimap.stat.assessment.grades_dataset.lib.grades_dataset import (
    DATASET_SCHEMA,
    make_dataset,
)
from nile.api.v1 import cli


@cli.statinfra_job(options=[
    cli.Option(
        'recalc-prior-days',
        default=MAX_GRADE_DELAY_DAYS,
        help=f'Also recalculate for dates prior to specified. Defaults to {MAX_GRADE_DELAY_DAYS}.',
    ),
])
def make_job(job, options):
    dataset_dates = extend_with_prior_days(options.dates, int(options.recalc_prior_days))
    unit_dates = extend_with_prior_days(dataset_dates, int(options.recalc_prior_days))

    make_dataset(
        grade_table=job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_grade'),
        graded_units_log=job.table('//home/maps-nmaps/analytics/assessment/graded_units_log/{' + ','.join(unit_dates) + '}'),
        puid_map=job.table('//home/maps-nmaps/analytics/tasks_payment/dictionaries/puid_map/' + max(unit_dates)),
        tariffs_with_dates=get_tables_with_names(job, '//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/task_tariff_map/', 'date', unit_dates),
        major_regions_map=job.table('//home/maps-nmaps/analytics/geo-data/major_regions_map'),
    ).call(
        put_tables_by_prefixes,
        '//home/maps/core/nmaps/analytics/assessment/datasets/grades/',
        'grade_date', dataset_dates,
        DATASET_SCHEMA,
    )

    return job


def main():
    cli.run()
