import nile.api.v1.datetime as nd
import datetime as dt

MAX_GRADE_DELAY_DAYS = 28 - 1


def get_yesterday():
    return nd.next_day(dt.date.today(), offset=-1).decode()


def extend_with_prior_days(dates, prior_days):
    '''
    Get dates extended with prior days.
    '''
    assert prior_days >= 0, 'Expected non-negative prior days'

    result = set()
    for date in dates:
        result.update(nd.date_range(
            nd.next_day(date, offset=-prior_days),
            date,
        ))

    return sorted(map(bytes.decode, result))
