from maps.wikimap.stat.assessment.libs.date_utils import (
    get_yesterday,
    extend_with_prior_days,
)
from freezegun import freeze_time
import pytest


def test_should_get_yesterday():
    with freeze_time('2021-01-01'):
        assert '2020-12-31' == get_yesterday()


def test_should_extend_with_prior_days():
    assert ['2021-07-01', '2021-07-03', '2021-07-04'] == extend_with_prior_days(['2021-07-01', '2021-07-03', '2021-07-04'], 0)
    assert ['2021-07-02', '2021-07-03', '2021-07-04'] == extend_with_prior_days(['2021-07-03', '2021-07-04'], 1)
    assert ['2021-07-01', '2021-07-02', '2021-07-03'] == extend_with_prior_days(['2021-07-03'], 2)


def test_should_fail_when_extending_with_negative_prior_days():
    with pytest.raises(AssertionError, match='Expected non-negative prior days'):
        extend_with_prior_days(['2021-07-01'], -1)
