from maps.wikimap.stat.assessment.report.lib.report import prepare_report

from nile.api.v1 import cli, statface
from yt.wrapper.ypath import ypath_join


_PROXY_TO_REPORT_PATH = {
    'upload.stat.yandex-team.ru': 'Maps.Wiki/Quality/Assessment',
    'upload.stat-beta.yandex-team.ru': 'Maps.Wiki/Quality/Assessment_2'
}


@cli.statinfra_job()
def make_report(job, options, statface_client):
    report = statface.StatfaceReport(
        path=_PROXY_TO_REPORT_PATH[statface_client.proxy],
        scale=options.scale,
        client=statface_client
    )

    for date in options.dates:
        prepare_report(
            job,
            date,
            job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_unit'),
            job.table('//home/maps/core/nmaps/analytics/tasks_payment/replica/assessment_nmaps-14585/assessment_grade'),
            job.table('//home/maps/core/nmaps/analytics/feedback/db/feedback_latest'),
            job.table('//home/maps/core/nmaps/dynamic/replica/social/social_commit_event'),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/moderation_log', date)),
            job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_active'),
            job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_closed'),
            job.table('//home/maps/core/nmaps/analytics/geo-data/major_regions_map'),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/task_tariff_map', date)),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/puid_map', date)),
            job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/issues'),
            job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/components'),
            job.table(ypath_join('//home/maps/core/nmaps/analytics/tasks_payment/tasks_logs/assessment_log', date)),
        ).publish(
            report
        )

    return job


def main():
    cli.run()
