import pytest


@pytest.fixture
def geom_fixture(monkeypatch):
    def geom_to_center_point_lat_lon_mock(fake_hex_encoded_mercator_wkb):
        if fake_hex_encoded_mercator_wkb is not None:
            coords = fake_hex_encoded_mercator_wkb.split(b', ')
        else:
            coords = [0, 0]

        return float(coords[0]), float(coords[1])

    monkeypatch.setattr(
        'maps.wikimap.stat.assessment.report.lib.util._geom_to_center_point_lat_lon',
        geom_to_center_point_lat_lon_mock
    )
