from maps.wikimap.stat.assessment.report.lib import edits

from maps.wikimap.stat.libs import nile_ut

from nile.api.v1 import Record


def test_should_get_edit_events():
    result = nile_ut.yt_run(
        edits._get_edit_events,
        '2021-01-25',
        commit_event_table=nile_ut.Table([
            Record(event_id=1, created_by=1, created_at=b'2021-01-24 01:01:01', action=b'action 1', bounds_geom=b'geom 1', primary_object_category_id=b'category 1', type=b'edit',  test_column=1),
            Record(event_id=2, created_by=2, created_at=b'2021-01-25 02:02:02', action=b'action 2', bounds_geom=b'geom 2', primary_object_category_id=b'category 2', type=b'edit',  test_column=2),
            Record(event_id=3, created_by=3, created_at=b'2021-01-25 03:03:03', action=b'action 3', bounds_geom=b'geom 3', primary_object_category_id=b'category 3', type=b'other', test_column=3),
        ])
    )

    assert sorted([
        Record(event_id=2, action_by=2, action=b'action 2', geom=b'geom 2', category_id=b'category 2'),
    ]) == sorted(result)


def test_should_get_non_moderating_events():
    result = nile_ut.yt_run(
        edits._get_non_moderating_events,
        edit_events=nile_ut.Table([
            Record(event_id=1, action_by=1, action=b'action 1', geom=b'geom 1', category_id=b'category 1'),
            Record(event_id=2, action_by=2, action=b'action 2', geom=b'geom 2', category_id=b'category 2'),
            Record(event_id=3, action_by=3, action=b'action 3', geom=b'geom 3', category_id=b'category 3'),
            Record(event_id=4, action_by=4, action=b'action 4', geom=b'geom 4', category_id=b'category 4'),
            Record(event_id=5, action_by=5, action=b'action 5', geom=b'geom 5', category_id=b'category 5'),
        ]),
        task_active_table=nile_ut.Table([
            Record(event_id=1),
            Record(event_id=3),
            Record(event_id=6),
        ]),
        task_closed_table=nile_ut.Table([
            Record(event_id=5),
            Record(event_id=7),
        ])
    )

    assert sorted([
        Record(action_by=2, action=b'action 2', geom=b'geom 2', category_id=b'category 2'),
        Record(action_by=4, action=b'action 4', geom=b'geom 4', category_id=b'category 4'),
    ]) == sorted(result)


def test_should_get_paid_tasks():
    result = nile_ut.yt_run(
        edits._get_paid_tasks,
        '2021-01-25',
        commit_event_table=nile_ut.Table([
            Record(event_id=1, created_by=1, created_at=b'2021-01-24 01:01:01', action=b'action 1', bounds_geom=b'geom 1', primary_object_category_id=b'category 1', type=b'edit',  test_column=1),
            Record(event_id=2, created_by=2, created_at=b'2021-01-25 02:02:02', action=b'action 2', bounds_geom=b'geom 2', primary_object_category_id=b'category 2', type=b'other', test_column=2),
            Record(event_id=3, created_by=3, created_at=b'2021-01-25 03:03:03', action=b'action 3', bounds_geom=b'geom 3', primary_object_category_id=b'category 3', type=b'edit',  test_column=3),
            Record(event_id=4, created_by=4, created_at=b'2021-01-25 04:04:04', action=b'action 4', bounds_geom=b'geom 4', primary_object_category_id=b'category 4', type=b'edit',  test_column=4),
            Record(event_id=5, created_by=5, created_at=b'2021-01-25 05:05:05', action=b'action 5', bounds_geom=b'geom 5', primary_object_category_id=b'category 5', type=b'edit',  test_column=5),
            Record(event_id=6, created_by=6, created_at=b'2021-01-25 06:06:06', action=b'action 6', bounds_geom=b'geom 6', primary_object_category_id=b'category 6', type=b'edit',  test_column=6),
        ]),
        task_active_table=nile_ut.Table([
            Record(event_id=3),
        ]),
        task_closed_table=nile_ut.Table([
            Record(event_id=5),
        ])
    )

    assert sorted([
        Record(action_by=4, action=b'action 4', geom=b'geom 4', category_id=b'category 4'),
        Record(action_by=6, action=b'action 6', geom=b'geom 6', category_id=b'category 6'),
    ]) == sorted(result)


def test_should_add_task_id():
    result = nile_ut.yt_run(
        edits._add_task_id,
        assessed_tasks=nile_ut.Table([
            Record(action_by=1, action=b'action 1', graded_by=11, grade=b'grade 1', geom=b'geom 1', category_id=b'category 1'),
            Record(action_by=2, action=b'action 2', graded_by=12, grade=b'grade 2', geom=b'geom 2', category_id=None),
        ])
    )

    assert sorted([
        Record(action_by=1, action=b'action 1', graded_by=11, grade=b'grade 1', geom=b'geom 1', task_id=b'edits/action 1/category 1'),
        Record(action_by=2, action=b'action 2', graded_by=12, grade=b'grade 2', geom=b'geom 2', task_id=b'edits/action 2/common'),
    ]) == sorted(result)


def test_should_get_tasks(geom_fixture):
    result = nile_ut.yt_run(
        edits.get_tasks,
        nile_ut.Job(),
        '2021-01-25',
        latest_grades=nile_ut.Table([
            Record(entity_id=b'4', action_by=4, action=b'action 4', graded_by=104, grade=b'grade 4'),
        ]),
        commit_event_table=nile_ut.Table([
            Record(event_id=1, created_by=1, created_at=b'2021-01-24 01:01:01', action=b'action 1', bounds_geom=b'11, 12', primary_object_category_id=b'category 1', type=b'edit',  test_column=1),
            Record(event_id=2, created_by=2, created_at=b'2021-01-25 02:02:02', action=b'action 2', bounds_geom=b'21, 22', primary_object_category_id=b'category 2', type=b'other', test_column=2),
            Record(event_id=3, created_by=3, created_at=b'2021-01-25 03:03:03', action=b'action 3', bounds_geom=b'31, 32', primary_object_category_id=b'category 3', type=b'edit',  test_column=3),
            Record(event_id=4, created_by=4, created_at=b'2021-01-25 04:04:04', action=b'action 4', bounds_geom=b'41, 42', primary_object_category_id=b'category 4', type=b'edit',  test_column=4),
            Record(event_id=5, created_by=5, created_at=b'2021-01-25 05:05:05', action=b'action 5', bounds_geom=b'51, 52', primary_object_category_id=b'category 5', type=b'edit',  test_column=5),
            Record(event_id=6, created_by=6, created_at=b'2021-01-25 06:06:06', action=b'action 6', bounds_geom=b'61, 62', primary_object_category_id=b'category 6', type=b'edit',  test_column=6),
        ]),
        task_active_table=nile_ut.Table([
            Record(event_id=3),
        ]),
        task_closed_table=nile_ut.Table([
            Record(event_id=5),
        ])
    )

    assert sorted([
        Record(lat=41.0, lon=42.0, task_id=b'edits/action 4/category 4', action_by=4, action=b'action 4', graded_by=104,  grade=b'grade 4'),
        Record(lat=41.0, lon=42.0, task_id=b'edits/action 4/category 4', action_by=4, action=b'action 4', graded_by=None, grade=None),
        Record(lat=61.0, lon=62.0, task_id=b'edits/action 6/category 6', action_by=6, action=b'action 6', graded_by=None, grade=None),
    ]) == sorted(result)
