from maps.wikimap.stat.assessment.report.lib import tracker

from maps.wikimap.stat.libs import nile_ut

from nile.api.v1 import Record
from yt.yson import to_yson_type


def test_should_get_assessed_tasks():
    result = nile_ut.yt_run(
        tracker._get_assessed_tasks,
        latest_grades=nile_ut.Table([
            Record(entity_id=b'queue-1', action_by=1, action=b'action 1', graded_by=11, grade=b'grade 1'),
            Record(entity_id=b'queue-3', action_by=3, action=b'action 3', graded_by=33, grade=b'grade 3'),
        ]),
        issues=nile_ut.Table([
            Record(key=b'queue-1', components=to_yson_type([b'component id 1']), issues_other_column=1),
            Record(key=b'queue-2', components=to_yson_type([b'component id 2']), issues_other_column=2),
            Record(key=b'queue-3', components=to_yson_type([b'component id 3']), issues_other_column=3),
        ]),
        components=nile_ut.Table([
            Record(id=b'component id 1', name=b'component 1', components_other_column=1),
            Record(id=b'component id 2', name=b'component 2', components_other_column=2),
            Record(id=b'component id 3', name=b'component 3', components_other_column=3),
        ])
    )

    assert sorted([
        Record(task_id=b'assessment/tracker/queue/component 1', action_by=1, action=b'action 1', graded_by=11, grade=b'grade 1', lat=None, lon=None),
        Record(task_id=b'assessment/tracker/queue/component 3', action_by=3, action=b'action 3', graded_by=33, grade=b'grade 3', lat=None, lon=None),
    ]) == sorted(result)


def test_should_get_paid_tasks():
    result = nile_ut.yt_run(
        tracker._get_paid_tasks,
        assessment_log=nile_ut.Table([
            Record(puid=1, task_id=b'assessment/tracker/queue/component 1', assessment_log_other_column=1),
            Record(puid=2, task_id=b'assessment/tracker/queue/component 2', assessment_log_other_column=2),
        ])
    )

    assert sorted([
        Record(task_id=b'assessment/tracker/queue/component 1', action_by=1, action=b'close', graded_by=None, grade=None, lat=None, lon=None),
        Record(task_id=b'assessment/tracker/queue/component 2', action_by=2, action=b'close', graded_by=None, grade=None, lat=None, lon=None),
    ]) == sorted(result)


def test_should_get_tasks():
    result = nile_ut.yt_run(
        tracker.get_tasks,
        job=nile_ut.Job(),
        latest_grades=nile_ut.Table([
            Record(entity_id=b'queue-1', action_by=1, action=b'action 1', graded_by=11, grade=b'grade 1'),
        ]),
        issues=nile_ut.Table([
            Record(key=b'queue-1', components=to_yson_type([b'component id 1'])),
            Record(key=b'queue-2', components=to_yson_type([b'component id 2'])),
        ]),
        components=nile_ut.Table([
            Record(id=b'component id 1', name=b'component 1'),
            Record(id=b'component id 2', name=b'component 2'),
        ]),
        assessment_log=nile_ut.Table([
            Record(puid=3, task_id=b'assessment/tracker/other-queue/component 3'),
        ])
    )

    assert sorted([
        Record(task_id=b'assessment/tracker/queue/component 1',       action_by=1, action=b'action 1', graded_by=11,   grade=b'grade 1', lat=None, lon=None),
        Record(task_id=b'assessment/tracker/other-queue/component 3', action_by=3, action=b'close',    graded_by=None, grade=None,       lat=None, lon=None),
    ]) == sorted(result)
