from maps.wikimap.stat.assessment.report.lib import util

from maps.wikimap.stat.libs import nile_ut

from nile.api.v1 import Record

from math import isclose


def test_should_filter_by_date():
    def filter_by_date(table):
        return table.filter(util.filter_by_date('column_to_filter_by', '2021-01-25'))

    result = nile_ut.yt_run(
        filter_by_date,
        table=nile_ut.Table([
            Record(column_to_filter_by=b'2021-01-24', other_column=1),
            Record(column_to_filter_by=b'2021-01-25', other_column=2),
            Record(column_to_filter_by=b'2021-01-26', other_column=3),
            Record(column_to_filter_by=b'2021-01-25', other_column=4),
        ])
    )

    assert sorted([
        Record(column_to_filter_by=b'2021-01-25', other_column=2),
        Record(column_to_filter_by=b'2021-01-25', other_column=4),
    ]) == sorted(result)


def test_should_convert_geom_to_center_point_lat_lon():
    lat, lon = util._geom_to_center_point_lat_lon(
        b'0103000020430D00000100000005000000D3DEE0E3A8EC464153CBD63ECEFC5A41D3DEE0E3A8EC46417B14AE51D6FC5A4'
        b'1EBAD81E9B6EC46417B14AE51D6FC5A41EBAD81E9B6EC464153CBD63ECEFC5A41D3DEE0E3A8EC464153CBD63ECEFC5A41'
    )
    assert isclose(lat, 53.6762770634)
    assert isclose(lon, 26.99228842025)


def test_should_get_atlantis_coords_for_wrong_geometry():
    lat, lon = util._geom_to_center_point_lat_lon(b'Wrong geometry')
    assert isclose(lat, 0.0)
    assert isclose(lon, 0.0)


def test_should_get_atlantis_coords_for_absent_geometry():
    lat, lon = util._geom_to_center_point_lat_lon(None)
    assert isclose(lat, 0.0)
    assert isclose(lon, 0.0)


def test_should_convert_geom_to_lat_lon(geom_fixture):
    result = nile_ut.yt_run(
        util.geom_to_lat_lon,
        table=nile_ut.Table([
            Record(action_by=1, action=b'action', graded_by=1, grade=1, geom=b'11, 12', task_id=b'task id'),
        ])
    )

    assert sorted([
        Record(lat=11, lon=12, action_by=1, action=b'action', graded_by=1, grade=1, task_id=b'task id'),
    ]) == sorted(result)


def test_should_get_assessed_tasks():
    result = nile_ut.yt_run(
        util.get_assessed_tasks,
        commit_event_table=nile_ut.Table([
            Record(event_id=1, bounds_geom=b'geometry 1', primary_object_category_id=b'category 1', test_column=1),
            Record(event_id=2, bounds_geom=b'geometry 2', primary_object_category_id=b'category 2', test_column=2),
            Record(event_id=3, bounds_geom=b'geometry 3', primary_object_category_id=b'category 3', test_column=3),
        ]),
        latest_grades=nile_ut.Table([
            Record(entity_id=b'1', action_by=1,  action=b'action 1',  graded_by=101, grade=b'grade 1'),
            Record(entity_id=b'2', action_by=21, action=b'action 21', graded_by=121, grade=b'grade 21'),
            Record(entity_id=b'2', action_by=22, action=b'action 22', graded_by=122, grade=b'grade 22'),
            Record(entity_id=b'4', action_by=4,  action=b'action 4',  graded_by=104, grade=b'grade 4'),
        ])
    )

    assert sorted([
        Record(action_by=1,  action=b'action 1',  graded_by=101, grade=b'grade 1',  geom=b'geometry 1', category_id=b'category 1'),
        Record(action_by=21, action=b'action 21', graded_by=121, grade=b'grade 21', geom=b'geometry 2', category_id=b'category 2'),
        Record(action_by=22, action=b'action 22', graded_by=122, grade=b'grade 22', geom=b'geometry 2', category_id=b'category 2'),
    ]) == sorted(result)


def test_should_concat_assessed_and_paid_tasks():
    result = nile_ut.yt_run(
        util.concat_assessed_and_paid_tasks,
        nile_ut.Job(),
        assessed_tasks=nile_ut.Table([
            Record(test_column_assessed_tasks=1, graded_by=1, grade=b'grade 1'),
            Record(test_column_assessed_tasks=2, graded_by=2, grade=b'grade 2'),
        ]),
        paid_tasks=nile_ut.Table([
            Record(test_column_paid_tasks=1),
            Record(test_column_paid_tasks=2),
        ])
    )

    assert sorted([
        Record(test_column_assessed_tasks=1, graded_by=1,    grade=b'grade 1'),
        Record(test_column_assessed_tasks=2, graded_by=2,    grade=b'grade 2'),
        Record(test_column_paid_tasks=1,     graded_by=None, grade=None),
        Record(test_column_paid_tasks=2,     graded_by=None, grade=None),
    ]) == sorted(result)
